﻿using StokYonetimSistemi.Business;
using System;
using System.Linq;
using System.Windows.Forms;

namespace StokYonetimSistemi.WinFormsUI
{
    public partial class frmStokGiris : Form
    {
        private readonly UrunManager _urunManager = new UrunManager();
        private readonly StokManager _stokManager = new StokManager();

        public frmStokGiris()
        {
            InitializeComponent();
        }

        private void frmStokGiris_Load(object sender, EventArgs e)
        {
            UrunleriListele();
            // Başlangıçta giriş kontrollerini pasif yap, ürün seçilince aktif olacak.
            GirisKontrolleriniAyarla(false);
        }

        private void UrunleriListele(string aramaMetni = null)
        {
            var urunler = _urunManager.TumUrunleriGetir();

            if (!string.IsNullOrEmpty(aramaMetni))
            {
                // Arama metnine göre ürünleri filtrele (büyük/küçük harf duyarsız)
                urunler = urunler.Where(u => u.Ad.ToLower().Contains(aramaMetni.ToLower()) ||
                                             (u.Barkod != null && u.Barkod.Contains(aramaMetni))).ToList();
            }

            dgvUrunler.DataSource = urunler;
            // İhtiyaç olmayan kolonları gizleyelim
            dgvUrunler.Columns["Kategori"].Visible = false;
            dgvUrunler.Columns["StokHareketleri"].Visible = false;
        }

        private void txtUrunAra_TextChanged(object sender, EventArgs e)
        {
            UrunleriListele(txtUrunAra.Text);
        }

        private void dgvUrunler_CellClick(object sender, DataGridViewCellEventArgs e)
        {
            if (dgvUrunler.CurrentRow != null)
            {
                lblSeciliUrun.Text = dgvUrunler.CurrentRow.Cells["Ad"].Value.ToString();
                GirisKontrolleriniAyarla(true);
            }
        }

        private void btnStokEkle_Click(object sender, EventArgs e)
        {
            if (dgvUrunler.CurrentRow == null)
            {
                MessageBox.Show("Lütfen stok girişi yapılacak bir ürün seçin!", "Uyarı", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return;
            }

            try
            {
                int urunId = (int)dgvUrunler.CurrentRow.Cells["Id"].Value;
                int miktar = (int)nudMiktar.Value;

                // Birim fiyat girildiyse decimal'e çevir, girilmediyse null bırak.
                decimal? birimFiyat = null;
                if (!string.IsNullOrWhiteSpace(txtBirimFiyat.Text))
                {
                    if (decimal.TryParse(txtBirimFiyat.Text, out decimal fiyat))
                    {
                        birimFiyat = fiyat;
                    }
                    else
                    {
                        MessageBox.Show("Lütfen geçerli bir fiyat girin.", "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        return;
                    }
                }

                // NOT: Gerçek bir uygulamada, giriş yapan kullanıcının ID'si
                // login işleminden sonra saklanır ve burada kullanılır.
                // Biz şimdilik 'admin' kullanıcısının ID'si olan 1'i varsayıyoruz.
                int kullaniciId = 1;

                _stokManager.StokGirisiYap(urunId, miktar, birimFiyat, kullaniciId);

                MessageBox.Show("Stok girişi başarıyla yapıldı!", "Başarılı", MessageBoxButtons.OK, MessageBoxIcon.Information);

                // İşlem sonrası listeyi yenile ve formu temizle
                UrunleriListele(txtUrunAra.Text);
                FormuTemizle();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Stok girişi sırasında bir hata oluştu:\n" + ex.Message, "Hata", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void GirisKontrolleriniAyarla(bool aktifMi)
        {
            nudMiktar.Enabled = aktifMi;
            txtBirimFiyat.Enabled = aktifMi;
            btnStokEkle.Enabled = aktifMi;
        }

        private void FormuTemizle()
        {
            lblSeciliUrun.Text = "-";
            nudMiktar.Value = 1;
            txtBirimFiyat.Clear();
            dgvUrunler.ClearSelection();
            GirisKontrolleriniAyarla(false);
        }
    }
}